package ru.yandex.qe.dispenser.domain.dao.bot;

import java.util.Objects;

import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.Service;

public class SimplePreOrder {
    private final Long id;
    private final Service service;
    @Nullable
    private final String configurationName;
    private final String bigOrderDate;
    @Nullable
    private final String bigOrderLocation;

    public SimplePreOrder(final Long id,
                          final Service service,
                          @Nullable final String configurationName,
                          final String bigOrderDate,
                          @Nullable final String bigOrderLocation) {
        this.id = id;
        this.service = service;
        this.configurationName = configurationName;
        this.bigOrderDate = bigOrderDate;
        this.bigOrderLocation = bigOrderLocation;
    }

    public Long getId() {
        return id;
    }

    public Service getService() {
        return service;
    }

    @Nullable
    public String getConfigurationName() {
        return configurationName;
    }

    public String getBigOrderDate() {
        return bigOrderDate;
    }

    @Nullable
    public String getBigOrderLocation() {
        return bigOrderLocation;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final SimplePreOrder that = (SimplePreOrder) o;
        return id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
