package ru.yandex.qe.dispenser.domain.dao.bot;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.dao.EmptyResultDataAccessException;

import ru.yandex.qe.dispenser.domain.index.LongIndexable;

public interface SyncableBotDao<T extends LongIndexable> {

    @NotNull
    Set<T> getAll();

    @NotNull
    Set<T> readAll(final Collection<Long> ids);

    @NotNull
    T read(final Long ids);

    @Nullable
    default T readOrNull(@NotNull final Long id) {
        try {
            return read(id);
        } catch (EmptyResultDataAccessException ignored) {
            return null;
        }
    }

    @NotNull
    Set<Long> getAllIds();

    void deleteByIds(Set<Long> toRemoveIds);

    T create(T configuration);

    boolean update(T configuration);

    void upsert(@NotNull final List<T> items);

    boolean clear();
}
