package ru.yandex.qe.dispenser.domain.dao.bot;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.dao.KeyExtractorInMemoryDaoImpl;
import ru.yandex.qe.dispenser.domain.index.LongIndexable;

public class SyncableBotDaoImpl<T extends LongIndexable> extends KeyExtractorInMemoryDaoImpl<T, Long>
        implements SyncableBotDao<T> {
    private final Function<T, T> deleteImpl;

    protected SyncableBotDaoImpl(final Function<T, T> deleteImpl) {
        super(LongIndexable::getId);
        this.deleteImpl = deleteImpl;
    }

    @Override
    @NotNull
    public Set<Long> getAllIds() {
        return id2obj.keySet();
    }

    @Override
    public void deleteByIds(final Set<Long> toRemoveIds) {
        toRemoveIds.forEach(id -> {
            id2obj.compute(id, (k, v) -> v == null ? null : deleteImpl.apply(v));
        });
    }

    @Override
    public void upsert(final List<T> items) {
        for (final T item : items) {
            id2obj.put(item.getId(), item);
        }
    }

    public Set<T> getByIds(final Collection<Long> ids) {
        return ids.stream()
                .filter(id2obj::containsKey)
                .map(id2obj::get)
                .collect(Collectors.toSet());
    }
}
