package ru.yandex.qe.dispenser.domain.dao.bot.configuration;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.qe.dispenser.domain.bot.Configuration;
import ru.yandex.qe.dispenser.domain.dao.bot.BotConfiguration;
import ru.yandex.qe.dispenser.domain.dao.bot.CompleteBotConfiguration;
import ru.yandex.qe.dispenser.domain.dao.bot.SyncableBotDao;

public interface BotConfigurationDao extends SyncableBotDao<BotConfiguration<? extends Configuration>> {

    default Set<Configuration> getAllConfigurations() {
        return getAll().stream()
                .map(BotConfiguration::getConfiguration)
                .collect(Collectors.toSet());
    }

    Map<Long, CompleteBotConfiguration> getConfigurationsInBigOrders(Set<Long> bigOrderIds);
}
