package ru.yandex.qe.dispenser.domain.dao.bot.monitoring;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.postgresql.util.PGobject;

import ru.yandex.qe.dispenser.api.v1.DiBotSyncStatus;
import ru.yandex.qe.dispenser.domain.bot.BotSyncStatus;
import ru.yandex.qe.dispenser.domain.dao.SqlDaoBase;
import ru.yandex.qe.dispenser.domain.dao.SqlUtils;

public class SqlBotSyncStatusDao extends SqlDaoBase implements BotSyncStatusDao {

    public static final TypeReference<List<String>> DATA_TYPE = new TypeReference<List<String>>() {
    };

    private static final long ID = 1L;

    private static final String  UPSERT_QUERY = "INSERT INTO bot_sync_status (id, status, date, errors) VALUES (" + ID + ", " +
            "cast(:status as bot_sync_status_statuses), :date, :errors)  ON CONFLICT (id) DO UPDATE SET " +
            "status = cast(:status as bot_sync_status_statuses), date = :date, errors = :errors WHERE bot_sync_status.id = " + ID;

    private static final String READ_QUERY = "SELECT status, date, errors FROM bot_sync_status WHERE id = " + ID;

    private static final String CLEAR_QUERY = "DELETE FROM bot_sync_status WHERE id = " + ID;

    @Override
    public @NotNull BotSyncStatus upsert(@NotNull final BotSyncStatus newStatus) {
        jdbcTemplate.update(UPSERT_QUERY, toParams(newStatus));
        return newStatus;
    }

    @Nullable
    @Override
    public BotSyncStatus read() {
        return jdbcTemplate.queryForOptional(READ_QUERY, Collections.emptyMap(), SqlBotSyncStatusDao::mapToBotSyncStatus).orElse(null);
    }

    @Override
    public boolean clean() {
        return jdbcTemplate.update(CLEAR_QUERY) > 0;
    }

    private static Map<String, ?> toParams(final BotSyncStatus botSyncStatus) {
        return ImmutableMap.of(
                "status", botSyncStatus.getStatus().name(),
                "date", Timestamp.from(botSyncStatus.getDate()),
                "errors", SqlUtils.toJsonb(botSyncStatus.getErrors())
        );
    }

    private static BotSyncStatus mapToBotSyncStatus(final ResultSet rs, final int i) throws SQLException {
        return BotSyncStatus.builder()
                .date(rs.getTimestamp("date").toInstant())
                .status(DiBotSyncStatus.Status.valueOf(rs.getString("status")))
                .errors(SqlUtils.fromJsonb((PGobject) rs.getObject("errors"), DATA_TYPE))
                .build();
    }
}
