package ru.yandex.qe.dispenser.domain.dao.bot.preorder;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.bot.MappedPreOrder;
import ru.yandex.qe.dispenser.domain.dao.bot.SimplePreOrder;

public interface MappedPreOrderDao {
    void createAll(Collection<MappedPreOrder> preOrders);

    Optional<MappedPreOrder> readById(final long id);

    Set<MappedPreOrder> readByProjectAndServiceAndBigOrders(final Project project, final Set<Service> services,
                                                            final Collection<Long> bigOrderIds, final long campaignGroupId);

    default Set<MappedPreOrder> readByProjectAndServiceAndBigOrder(final Project project, final Service service,
                                                                   final Long bigOrderId, final long campaignGroupId) {
        return readByProjectAndServiceAndBigOrders(project, Collections.singleton(service), Collections.singleton(bigOrderId), campaignGroupId);
    }

    boolean updateAll(Collection<MappedPreOrder> preOrders);

    boolean deleteAll(Collection<MappedPreOrder> preOrders);

    void lockForChanges();

    Set<Long> getOrdersIdsInStatus(final Set<Long> preOrderIdsToCheck, final MappedPreOrder.Status status);

    boolean hasPreOrdersInCampaignGroup(final long campaignGroupId);

    boolean hasPreOrdersInCampaignGroupForOrdersOtherThan(final long campaignGroupId, final Set<Long> orderIds);

    @TestOnly
    boolean clear();

    Collection<SimplePreOrder> readSimplePreOrders(Set<Long> ids);

    Map<Long, MappedPreOrder> getPreOrdersByBigOrderIds(Set<Long> bigOrderIds);
}
