package ru.yandex.qe.dispenser.domain.dao.bot.preorder.change;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import org.jetbrains.annotations.TestOnly;

public interface BotPreOrderChangeDao {
    void updateOrderChanges(long preOrderId, Map<Long, Double> changeIds);

    void setOrderChanges(long preOrderId, Map<Long, Double> changeIds);

    Set<Long> getOrderChangeIds(long preOrderId);

    Multimap<Long, Long> getPreOrderIdsByRequestId(Collection<Long> requestIds);

    Multimap<Long, Long> getRequestsIdsByPreOrderIds(Collection<Long> preOrderIds);

    @TestOnly
    boolean clear();

    /**
     * @return {@code Table(changeId, preOrderId -> proportion)}
     */
    Table<Long, Long, Double> getPreOrderIdsByChangeId(final Collection<Long> requestIds);

    Table<Long, Long, Double> getPreOrderChangesByBigOrderId(Collection<Long> bigOrderIds);
}
