package ru.yandex.qe.dispenser.domain.dao.bot.preorder.request;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import com.google.common.collect.SetMultimap;
import org.jetbrains.annotations.TestOnly;

public interface BotPreOrderRequestDao {
    Set<Long> getRequestsIdsByPreorderId(long id);

    void removeOrderRequests(Set<Long> preOrderIds);

    void createOrderRequests(Collection<PreOrderRequest> requests);

    SetMultimap<Long, Long> getRequestsIdsByPreOrderIds(Set<Long> preOrdersIds);

    SetMultimap<Long, Long> getPreOrderIdsByRequestId(Collection<Long> requestsIds);

    Collection<ExtendedPreOrderRequest> getRequestPreorders(final Set<Long> requestIds);

    default Collection<ExtendedPreOrderRequest> getRequestPreorders(final long requestId) {
        return getRequestPreorders(Collections.singleton(requestId));
    }

    Collection<PreOrderRequest> getRequestPreordersByBigOrderIds(final Set<Long> bigOrderIds);

    @TestOnly
    boolean clear();
}
