package ru.yandex.qe.dispenser.domain.dao.bot.preorder.request;

public class ExtendedPreOrderRequest {
    private final long requestId;
    private final double serversQuantity;
    private final long preOrderId;
    private final String configurationName;
    private final long preOrderServersQuantity;
    private final double cost;
    private final String preOrderName;
    private final long serviceId;
    private final double reserveRate;
    private final long bigOrderConfigId;

    public ExtendedPreOrderRequest(final long requestId,
                                   final long preOrderId,
                                   final double serversQuantity,
                                   final double cost,
                                   final String configurationName,
                                   final long preOrderServersQuantity,
                                   final String preOrderName,
                                   final long serviceId,
                                   final double reserveRate,
                                   final long bigOrderConfigId) {
        this.requestId = requestId;
        this.serversQuantity = serversQuantity;
        this.preOrderId = preOrderId;
        this.configurationName = configurationName;
        this.preOrderServersQuantity = preOrderServersQuantity;
        this.cost = cost;
        this.preOrderName = preOrderName;
        this.serviceId = serviceId;
        this.reserveRate = reserveRate;
        this.bigOrderConfigId = bigOrderConfigId;
    }

    public long getRequestId() {
        return requestId;
    }

    public double getServersQuantity() {
        return serversQuantity;
    }

    public long getPreOrderId() {
        return preOrderId;
    }

    public String getConfigurationName() {
        return configurationName;
    }

    public long getPreOrderServersQuantity() {
        return preOrderServersQuantity;
    }

    public double getCost() {
        return cost;
    }

    public String getPreOrderName() {
        return preOrderName;
    }

    public long getServiceId() {
        return serviceId;
    }

    public double getReserveRate() {
        return reserveRate;
    }

    public long getBigOrderConfigId() {
        return bigOrderConfigId;
    }
}
