package ru.yandex.qe.dispenser.domain.dao.bot.preorder.request;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PreOrderRequest {
    private final Key key;
    private final Value value;

    public PreOrderRequest(final Key key, final Value value) {
        this.key = key;
        this.value = value;
    }

    public Key getKey() {
        return key;
    }

    public Value getValue() {
        return value;
    }

    public static class Key {
        private final long preOrderId;
        private final long requestId;

        public Key(final long preOrderId, final long requestId) {
            this.preOrderId = preOrderId;
            this.requestId = requestId;
        }

        public long getRequestId() {
            return requestId;
        }

        public long getPreOrderId() {
            return preOrderId;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Key key = (Key) o;
            return requestId == key.requestId &&
                    preOrderId == key.preOrderId;
        }

        @Override
        public int hashCode() {
            return Objects.hash(requestId, preOrderId);
        }

        @Override
        public String toString() {
            return "Key{" +
                    "requestId=" + requestId +
                    ", preOrderId=" + preOrderId +
                    '}';
        }
    }

    public static class Value {
        private final double servers;
        private final double cost;

        public Value(final double servers, final double cost) {
            this.servers = servers;
            this.cost = cost;
        }

        public double getServerQuantity() {
            return servers;
        }

        public double getCost() {
            return cost;
        }
    }
}
