package ru.yandex.qe.dispenser.domain.dao.bot.preorder.request;

import org.jetbrains.annotations.Nullable;

public class ReportPreOrderRequest {
    private final long requestId;
    private final double serversQuantity;
    private final long preOrderId;
    private final String configurationName;
    private final long preOrderServersQuantity;
    private final double cost;
    private final long serviceId;
    private final String bigOrderDate;
    @Nullable
    private final String bigOrderLocation;

    public ReportPreOrderRequest(final long requestId,
                                 final long preOrderId,
                                 final double serversQuantity,
                                 final double cost,
                                 final String configurationName,
                                 final long preOrderServersQuantity,
                                 final long serviceId,
                                 final String bigOrderDate,
                                 @Nullable final String bigOrderLocation) {
        this.requestId = requestId;
        this.serversQuantity = serversQuantity;
        this.preOrderId = preOrderId;
        this.configurationName = configurationName;
        this.preOrderServersQuantity = preOrderServersQuantity;
        this.cost = cost;
        this.bigOrderDate = bigOrderDate;
        this.bigOrderLocation = bigOrderLocation;
        this.serviceId = serviceId;
    }

    public long getRequestId() {
        return requestId;
    }

    public double getServersQuantity() {
        return serversQuantity;
    }

    public long getPreOrderId() {
        return preOrderId;
    }

    public String getConfigurationName() {
        return configurationName;
    }

    public long getPreOrderServersQuantity() {
        return preOrderServersQuantity;
    }

    public double getCost() {
        return cost;
    }

    public long getServiceId() {
        return serviceId;
    }

    public String getBigOrderDate() {
        return bigOrderDate;
    }

    @Nullable
    public String getBigOrderLocation() {
        return bigOrderLocation;
    }
}
