package ru.yandex.qe.dispenser.domain.dao.bot.provider.group;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.qe.dispenser.domain.ProviderGroup;
import ru.yandex.qe.dispenser.domain.dao.InMemoryLongKeyDaoImpl;

public class ProviderGroupDaoImpl extends InMemoryLongKeyDaoImpl<ProviderGroup> implements ProviderGroupDao {
    @Override
    public List<ProviderGroup> getProviderGroupsByCampaignId(final long campaignId) {
        return filter(pg -> campaignId == pg.getCampaignId())
                .sorted(Comparator.comparing(ProviderGroup::getPriority))
                .collect(Collectors.toList());
    }


    @Override
    public boolean clear() {
        return super.clear();
    }
}
