package ru.yandex.qe.dispenser.domain.dao.bot.provider.group.report;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableMap;
import org.postgresql.util.PGobject;

import ru.yandex.qe.dispenser.domain.ProviderGroupReport;
import ru.yandex.qe.dispenser.domain.dao.SqlDaoBase;
import ru.yandex.qe.dispenser.domain.dao.SqlUtils;

public class SqlProviderGroupReportDao extends SqlDaoBase implements ProviderGroupReportDao {
    private static final String UPSERT_PROVIDER_GROUP_REPORT = "INSERT INTO provider_group_report (provider_group_id, report) VALUES (:providerGroupId, :report) ON CONFLICT (provider_group_id) DO UPDATE SET report = :report";

    private static final String GET_REPORT_BY_CAMPAIGN_ID = "SELECT pg.name, pg.description, pg.priority, pgp.* FROM provider_group pg JOIN provider_group_report pgp ON pgp.provider_group_id = pg.id WHERE pg.campaign_id IN (:campaignId) ORDER BY pg.priority";

    private static final String CLEAR_QUERY = "TRUNCATE provider_group_report";

    @Override
    public void upsertProviderGroupReport(final long providerGroupId, final ProviderGroupReport.Report report) {
        jdbcTemplate.update(UPSERT_PROVIDER_GROUP_REPORT, ImmutableMap.of(
                "providerGroupId", providerGroupId,
                "report", SqlUtils.toJsonb(report)
        ));
    }

    @Override
    public List<ProviderGroupReport> getByCampaignId(final long campaignId) {
        return jdbcTemplate.query(GET_REPORT_BY_CAMPAIGN_ID, Collections.singletonMap("campaignId", campaignId), this::toProviderGroupReport);
    }

    @Override
    public boolean clear() {
        return jdbcTemplate.update(CLEAR_QUERY) > 0;
    }

    private ProviderGroupReport toProviderGroupReport(final ResultSet rs, final int ignored) throws SQLException {
        return new ProviderGroupReport(
                rs.getLong("provider_group_id"),
                rs.getString("name"),
                rs.getString("description"),
                rs.getInt("priority"),
                SqlUtils.fromJsonb((PGobject) rs.getObject("report"), ProviderGroupReport.Report.class)
        );
    }
}

