package ru.yandex.qe.dispenser.domain.dao.bot.remainder;

import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.InMemoryLongKeyDaoImpl;
import ru.yandex.qe.dispenser.domain.dao.bot.ServersRemainder;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class ServersRemainderDaoImpl extends InMemoryLongKeyDaoImpl<ServersRemainder> implements ServersRemainderDao {

    @Override
    public Set<ServersRemainder> getByCampaignGroup(long campaignGroupId) {
        return filter(sr -> sr.getBotCampaignGroupId() == campaignGroupId)
                .collect(Collectors.toSet());
    }

    @Override
    public void removeByCampaignGroupAndServices(long campaignGroupId, final Set<Service> services) {
        filter(sr -> sr.getBotCampaignGroupId() == campaignGroupId && services.contains(sr.getService()))
                .forEach(this::delete);
    }

    @Override
    public void createAll(Collection<ServersRemainder> serversRemainders) {
        serversRemainders
                .forEach(this::create);
    }

    @Override
    public boolean clear() {
        return super.clear();
    }
}
