package ru.yandex.qe.dispenser.domain.dao.bot.service;

import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.bot.BotServiceConfiguration;

import java.util.Collection;
import java.util.Set;

public interface BotServiceConfigurationDao {
    Set<BotServiceConfiguration> getByService(Service service);

    Set<BotServiceConfiguration> getByService(Service service, long botCampaignGroupId);

    Set<BotServiceConfiguration> getByServices(Collection<Service> services);

    Set<BotServiceConfiguration> getByServices(Collection<Service> services, long botCampaignGroupId);

    Set<BotServiceConfiguration.View> getByServiceViews(Service service);

    Set<BotServiceConfiguration.View> getByServiceViews(Service service, long botCampaignGroupId);

    void deleteByService(Service service, long botCampaignGroupId);

    void createAll(Set<BotServiceConfiguration> configurations);

    Set<Long> getConfigurationsIds();

    boolean clear();

    void updateAll(Set<BotServiceConfiguration> configurations);
}
