package ru.yandex.qe.dispenser.domain.dao.bot.service.reserve;

import java.util.Set;

import ru.yandex.qe.dispenser.domain.Campaign;
import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.dao.InMemoryKeyDao;

public interface BotServiceReserveDao extends InMemoryKeyDao.Normalized<BotServiceReserve, BotServiceReserve.Key>, BotReserveDao<BotServiceReserve> {

    Set<BotServiceReserve> getReservesByBigOrders(final Set<Campaign.CampaignIdOrderId> campaignOrderIds);

    boolean hasReservesInCampaign(final long campaignId);

    boolean hasReservesInCampaignForOrdersOtherThan(final long campaignId, final Set<Long> orderIds);

    void updateSegments(final long reserveId, Set<Segment> segments);
}
