package ru.yandex.qe.dispenser.domain.dao.bot.settings;

import org.springframework.dao.EmptyResultDataAccessException;
import ru.yandex.qe.dispenser.domain.BotCampaignGroup;
import ru.yandex.qe.dispenser.domain.BotCampaignGroupUpdate;
import ru.yandex.qe.dispenser.domain.dao.InMemoryDao;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public interface BotCampaignGroupDao extends InMemoryDao<BotCampaignGroup, Long> {
    Set<BotCampaignGroup> getActiveGroups();

    Optional<BotCampaignGroup> readOptional(long id);

    BotCampaignGroup readForUpdate(long id) throws EmptyResultDataAccessException;

    BotCampaignGroup partialUpdate(final BotCampaignGroup group, final BotCampaignGroupUpdate update);

    Optional<BotCampaignGroup> getByCampaign(long campaignId);

    boolean hasGroupForCampaign(long campaignId);

    void attachCampaigns(final long groupId, final Collection<Long> campaigns);

    void detachCampaigns(final long groupId, final Collection<Long> campaigns);

    void attachBigOrders(final long groupId, final Collection<Long> bigOrders);

    void detachBigOrders(final long groupId, final Collection<Long> bigOrders);
}
