package ru.yandex.qe.dispenser.domain.dao.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.qe.dispenser.domain.CampaignOwningCost;


public class CampaignOwningCostDaoImpl implements CampaignOwningCostDao {
    Map<Long, CampaignOwningCost> map = new HashMap<>();

    @Override
    public List<CampaignOwningCost> readAll() {
        return new ArrayList<>(map.values());
    }

    @Override
    public CampaignOwningCost read(long campaignId) {
        return map.get(campaignId);
    }

    @Override
    public void upsertAll(Collection<CampaignOwningCost> campaignOwningCosts) {
        campaignOwningCosts
                .forEach(campaignOwningCost -> map.put(campaignOwningCost.getCampaignId(), campaignOwningCost));
    }

    @Override
    public void clear() {
        map.clear();
    }
}
