package ru.yandex.qe.dispenser.domain.dao.campaign;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.CampaignResource;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Segmentation;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.InMemoryDao;

public interface CampaignResourceDao extends InMemoryDao<CampaignResource, Long> {

    @NotNull
    List<CampaignResource> getByCampaignId(final long campaignId);

    @NotNull
    List<CampaignResource> getByResourceId(final long resourceId);

    @NotNull
    Map<Long, Set<Long>> getAvailableCampaignsForServices(@NotNull final Set<Service> services);

    @NotNull
    Map<Long, Set<Long>> getAvailableCampaignsForResources(@NotNull final Set<Resource> resources);

    @NotNull
    Map<Long, Set<Long>> getAvailableCampaignsForSegmentations(@NotNull final Set<Segmentation> segmentations);

    boolean existsByResource(@NotNull final Resource resource);

    boolean existsByService(@NotNull final Service service);

}
