package ru.yandex.qe.dispenser.domain.dao.campaign;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.qe.dispenser.domain.CampaignOwningCost;
import ru.yandex.qe.dispenser.domain.dao.SqlDaoBase;

public class SqlCampaignOwningCostDao extends SqlDaoBase implements CampaignOwningCostDao {
    private static final String READ_ALL_QUERY = "SELECT * FROM campaign_owning_cost";
    private static final String READ_QUERY = READ_ALL_QUERY + " WHERE campaign_id = :campaignId";
    private static final String CLEAR_QUERY = "TRUNCATE campaign_owning_cost CASCADE";
    private static final String VALUES = "%values%";
    private static final String UPSERT_ALL_QUERY = "INSERT INTO campaign_owning_cost " +
            "(campaign_id, owning_cost) " +
            "VALUES " + VALUES + " " +
            "ON CONFLICT (campaign_id) DO UPDATE SET " +
            "owning_cost = EXCLUDED.owning_cost";

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public List<CampaignOwningCost> readAll() {
        return jdbcTemplate.query(READ_ALL_QUERY, Collections.emptyMap(), (rs, rowNum) -> mapRow(rs));
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public CampaignOwningCost read(long campaignId) {
        List<CampaignOwningCost> owningCostList = jdbcTemplate.query(READ_QUERY, Map.of("campaignId",
                String.valueOf(campaignId)), (rs, rowNum) -> mapRow(rs));
        return owningCostList.size() == 1 ? owningCostList.get(0) : null;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public void upsertAll(Collection<CampaignOwningCost> campaignOwningCosts) {
        if (campaignOwningCosts.isEmpty()) {
            return;
        }

        String values = campaignOwningCosts.stream()
                .map(campaignOwningCost -> Stream.of(String.valueOf(campaignOwningCost.getCampaignId()),
                        campaignOwningCost.getOwningCost().toString()).collect(Collectors.joining(",", "(", ")")))
                .collect(Collectors.joining(","));

        String[] strings = {UPSERT_ALL_QUERY.replace(VALUES, values)};
        jdbcTemplate.batchUpdate(strings);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public void clear() {
        jdbcTemplate.update(CLEAR_QUERY);
    }

    private CampaignOwningCost mapRow(ResultSet rs) throws SQLException {
        final long campaignId = rs.getLong("campaign_id");
        BigInteger owningCost = new BigInteger(rs.getString("owning_cost"));
        return CampaignOwningCost.builder()
                .campaignId(campaignId)
                .owningCost(owningCost)
                .build();
    }
}
