package ru.yandex.qe.dispenser.domain.dao.delivery;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.annotation.Nullable;

import ru.yandex.qe.dispenser.domain.resources_model.QuotaRequestDelivery;

public interface DeliveryDao {

    List<QuotaRequestDelivery> getUnresolvedByQuotaRequestIdAndProviderId(long quotaRequestId, long providerId);

    QuotaRequestDelivery readForUpdate(UUID id);

    List<QuotaRequestDelivery> readAll();

    List<QuotaRequestDelivery> getByRequestIds(Set<Long> quotaRequestIds);

    List<QuotaRequestDelivery> getUnresolved(long limit, @Nullable UUID fromId);

    void create(QuotaRequestDelivery delivery);

    void update(QuotaRequestDelivery delivery);

    void remove(QuotaRequestDelivery delivery);

    void clear();

}
