package ru.yandex.qe.dispenser.domain.dao.dispenser_admins;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Person;

public class DispenserAdminsDaoImpl implements DispenserAdminsDao {
    @NotNull
    private final Set<Person> dispenserAdmins = new HashSet<>();


    @Override
    public boolean setDispenserAdmins(@NotNull final Collection<Person> admins) {
        dispenserAdmins.clear();
        return dispenserAdmins.addAll(admins);
    }


    @Override
    public @NotNull Set<Person> getDispenserAdmins() {
        return Collections.unmodifiableSet(dispenserAdmins);
    }
}
