package ru.yandex.qe.dispenser.domain.dao.dispenser_admins;

import java.util.Collection;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.dao.SqlDaoBase;

public class SqlDispenserAdminsDao extends SqlDaoBase implements DispenserAdminsDao {
    private static final String GET_ALL_ADMINS_QUERY = "SELECT person.id, login, person.uid, person.is_robot, person.is_dismissed, person.is_deleted, person.affiliation FROM person, dispenser_admin WHERE person.id = dispenser_admin.person_id";
    private static final String SET_ADMINS_QUERY = "INSERT INTO dispenser_admin (person_id) VALUES (:personId)";
    private static final String DELETE_ADMINS_QUERY = "DELETE FROM dispenser_admin";

    @Override
    public @NotNull Set<Person> getDispenserAdmins() {
        return jdbcTemplate.queryForSet(GET_ALL_ADMINS_QUERY, this::toPerson);
    }

    @Override
    public boolean setDispenserAdmins(@NotNull final Collection<Person> admins) {
        jdbcTemplate.execute(DELETE_ADMINS_QUERY);
        return changePersons(SET_ADMINS_QUERY, admins);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    protected boolean changePersons(@NotNull final String sql, @NotNull final Collection<Person> admins) {
        final SqlParameterSource[] modifications = admins.stream()
                .map(admin -> new MapSqlParameterSource(ImmutableMap.of("personId", admin.getId())))
                .toArray(SqlParameterSource[]::new);
        return jdbcTemplate.batchUpdate(sql, modifications).length > 0;
    }

}
