package ru.yandex.qe.dispenser.domain.dao.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.support.EntityUsageDiff;
import ru.yandex.qe.dispenser.domain.support.QuotaDiff;

final class BatchDiff {
    @NotNull
    private final List<EntityUsageDiff> usageDiffs = new ArrayList<>();
    @NotNull
    private final List<QuotaDiff> quotaDiffs = new ArrayList<>();

    @NotNull
    public List<EntityUsageDiff> getUsageDiffs() {
        return Collections.unmodifiableList(usageDiffs);
    }

    public boolean addUsageDiff(@NotNull final EntityUsageDiff usageDiff) {
        return usageDiffs.add(usageDiff);
    }

    @NotNull
    public List<QuotaDiff> getQuotaDiffs() {
        return Collections.unmodifiableList(quotaDiffs);
    }

    public boolean addQuotaDiff(@NotNull final QuotaDiff quotaDiff) {
        return quotaDiffs.add(quotaDiff);
    }

    public void merge(@NotNull final BatchDiff other) {
        quotaDiffs.addAll(other.quotaDiffs);
        usageDiffs.addAll(other.usageDiffs);
    }
}
