package ru.yandex.qe.dispenser.domain.dao.entity;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.DtoBuilder;

public class EntityFilteringParams {
    private final boolean trashOnly;
    @Nullable
    private final Long createdFrom;
    @Nullable
    private final Long createdTo;
    @Nullable
    private final Long expiredFrom;
    @Nullable
    private final Long expiredTo;
    @Nullable
    private final Integer offset;
    @Nullable
    private final Integer limit;

    private EntityFilteringParams(@NotNull final Builder builder) {
        this.trashOnly = builder.trashOnly;
        this.createdFrom = builder.createdFrom;
        this.createdTo = builder.createdTo;
        this.expiredFrom = builder.expiredFrom;
        this.expiredTo = builder.expiredTo;
        this.offset = builder.offset;
        this.limit = builder.limit;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static EntityFilteringParams noFiltering() {
        return builder().build();
    }

    public boolean trashOnly() {
        return trashOnly;
    }

    @Nullable
    public Integer getOffset() {
        return offset;
    }

    @Nullable
    public Integer getLimit() {
        return limit;
    }

    @Nullable
    public Long getCreatedFrom() {
        return createdFrom;
    }

    @Nullable
    public Long getCreatedTo() {
        return createdTo;
    }

    @Nullable
    public Long getExpiredFrom() {
        return expiredFrom;
    }

    @Nullable
    public Long getExpiredTo() {
        return expiredTo;
    }

    public static class Builder implements DtoBuilder<EntityFilteringParams> {
        private boolean trashOnly;
        @Nullable
        private Long createdFrom;
        @Nullable
        private Long createdTo;
        @Nullable
        private Long expiredFrom;
        @Nullable
        private Long expiredTo;
        @Nullable
        private Integer offset;
        @Nullable
        private Integer limit;

        @NotNull
        public Builder trashOnly(final boolean trashOnly) {
            this.trashOnly = trashOnly;
            return this;
        }

        @NotNull
        public Builder createdFrom(@Nullable final Long createdFrom) {
            this.createdFrom = createdFrom;
            return this;
        }

        @NotNull
        public Builder createdTo(@Nullable final Long createdTo) {
            this.createdTo = createdTo;
            return this;
        }

        @NotNull
        public Builder expiredFrom(@Nullable final Long expiredFrom) {
            this.expiredFrom = expiredFrom;
            return this;
        }

        @NotNull
        public Builder expiredTo(@Nullable final Long expiredTo) {
            this.expiredTo = expiredTo;
            return this;
        }

        @NotNull
        public Builder offset(@Nullable final Integer offset) {
            this.offset = offset;
            return this;
        }

        @NotNull
        public Builder limit(@Nullable final Integer limit) {
            this.limit = limit;
            return this;
        }

        @NotNull
        @Override
        public EntityFilteringParams build() {
            return new EntityFilteringParams(this);
        }
    }
}
