package ru.yandex.qe.dispenser.domain.dao.entity;

import java.util.Collection;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Quota;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaDao;
import ru.yandex.qe.dispenser.domain.support.QuotaDiff;

interface IntegratedEntityDao extends EntityDao {
    @NotNull
    @Override
    default Set<Quota> reshareQuota(@NotNull final Collection<QuotaDiff> quotaDiffs) {
        return getQuotaDao().finalizeAndChangeAll(quotaDiffs);
    }

    @NotNull
    QuotaDao getQuotaDao();
}
