package ru.yandex.qe.dispenser.domain.dao.entity;

import java.util.Arrays;

import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QuotaSharer {
    INSTANCE;

    private static final Logger LOG = LoggerFactory.getLogger(QuotaSharer.class);

    @NotNull
    public long[] share(final long size, @NotNull final int[] usages) {
        if (usages.length == 0) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        final String message = "Quota can't be shared: " + size + " / " + Arrays.toString(usages);
        for (final int usage : usages) {
            if (usage < 0) {
                throw new IllegalStateException(message);
            }
        }
        final int sumUsages = Arrays.stream(usages).sum();
        if (sumUsages == 0) {
            throw new IllegalStateException(message);
        }

        final long[] quotas = new long[usages.length];
        for (int i = 0; i < quotas.length; i++) {
            quotas[i] = size * usages[i] / sumUsages;
        }
        final long residual = size - Arrays.stream(quotas).sum();
        for (int i = 0; i < residual; i++) {
            quotas[i % quotas.length]++;
        }

        if (LOG.isTraceEnabled()) {
            LOG.trace("Quota shared: {} / {} = {}", size, Arrays.toString(usages), Arrays.toString(quotas));
        }
        return quotas;
    }
}
