package ru.yandex.qe.dispenser.domain.dao.entity;

import java.util.Arrays;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.EntitySpec;

public enum SqlEntityDaoUtils {
    ;

    @NotNull
    public static String toEntityTableNameUnquoted(@NotNull final EntitySpec spec) {
        return "entity_" + spec.getService().getKey() + "_" + spec.getKey().getPublicKey();
    }

    @NotNull
    public static String toEntityTableName(@NotNull final EntitySpec spec) {
        return "\"" + toEntityTableNameUnquoted(spec) + "\"";
    }

    @NotNull
    private static String toEntityUsageTableNameUnquot(@NotNull final EntitySpec spec) {
        return "entity_usage_" + spec.getService().getKey() + "_" + spec.getKey().getPublicKey();
    }

    @NotNull
    public static String toEntityUsageTableName(@NotNull final EntitySpec spec) {
        return "\"" + toEntityUsageTableNameUnquot(spec) + "\"";
    }

    @NotNull
    public static String formatEntityTable(@NotNull final String sql, @NotNull final EntitySpec... specs) {
        return String.format(sql, Arrays.stream(specs).map(SqlEntityDaoUtils::toEntityTableName).collect(Collectors.joining(", ")));
    }

    @NotNull
    public static String formatEntityUsageTable(@NotNull final String sql, @NotNull final EntitySpec... specs) {
        return String.format(sql, Arrays.stream(specs).map(SqlEntityDaoUtils::toEntityUsageTableName).collect(Collectors.joining(", ")));
    }

    @NotNull
    public static String usagesPrimaryKeyName(@NotNull final EntitySpec spec) {
        return "\"" + toEntityUsageTableNameUnquot(spec) + "_pkey\"";
    }

    @NotNull
    public static String usagesIndexName(@NotNull final EntitySpec spec) {
        return "\"" + toEntityUsageTableNameUnquot(spec) + "_idx\"";
    }

    @NotNull
    public static String usagesConstraintName(@NotNull final EntitySpec spec) {
        return "\"" + toEntityUsageTableNameUnquot(spec) + "_constraint\"";
    }

    @NotNull
    public static String entityCreationTimeIndexName(@NotNull final EntitySpec spec) {
        return "\"" + toEntityTableNameUnquoted(spec) + "_creation_time_idx\"";
    }

    @NotNull
    public static String entityExpirationTimeIndexName(@NotNull final EntitySpec spec) {
        return "\"" + toEntityTableNameUnquoted(spec) + "_expiration_time_idx\"";
    }
}
