package ru.yandex.qe.dispenser.domain.dao.entity.meta;

import java.util.Set;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.EntityMetaType;
import ru.yandex.qe.dispenser.domain.EntitySpec;
import ru.yandex.qe.dispenser.domain.dao.InMemoryKeyDao;

public interface EntityMetaTypeDao extends InMemoryKeyDao.Normalized<EntityMetaType<?>, EntityMetaType.Key>, EntityMetaTypeReader {
    @NotNull
    @Override
    default Set<EntityMetaType<?>> getBySpec(@NotNull final EntitySpec spec) {
        return getAll().stream().filter(mt -> mt.getSpec().equals(spec)).collect(Collectors.toSet());
    }
}
