package ru.yandex.qe.dispenser.domain.dao.entity.spec;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.EntitySpec;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.dao.InMemoryKeyDao;

public interface EntitySpecDao extends InMemoryKeyDao.Normalized<EntitySpec, EntitySpec.Key>, EntitySpecReader {
    @NotNull
    @Override
    default EntitySpec read(@NotNull final EntitySpec.Key key) {
        return InMemoryKeyDao.Normalized.super.read(key);
    }

    boolean addRelations(@NotNull EntitySpec spec, @NotNull Collection<Resource> resources);
}
