package ru.yandex.qe.dispenser.domain.dao.entity.spec;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.EntitySpec;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.dao.InMemoryLongKeyDaoImpl;

public class EntitySpecDaoImpl extends InMemoryLongKeyDaoImpl<EntitySpec> implements EntitySpecDao {
    @Override
    public boolean addRelations(@NotNull final EntitySpec spec, @NotNull final Collection<Resource> newResources) {
        final Set<Resource> allResources = new HashSet<>(spec.getResources());
        allResources.addAll(newResources);
        final EntitySpec updatedSpec = EntitySpec.builder()
                .withKey(spec.getKey().getPublicKey())
                .withDescription(spec.getDescription())
                .withCustomTag(spec.getTag())
                .overResources(allResources)
                .build();
        update(updatedSpec);
        return true;
    }
}
