package ru.yandex.qe.dispenser.domain.dao.entity.spec;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.EntitySpec;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.ReadOnlyDao;

public interface EntitySpecReader extends ReadOnlyDao.Normalized<EntitySpec, EntitySpec.Key> {
    @NotNull
    Set<EntitySpec> getAll();

    @NotNull
    default Set<EntitySpec> getByServices(@NotNull final Collection<Service> services) {
        return getAll().stream().filter(spec -> services.contains(spec.getService())).collect(Collectors.toSet());
    }
}
