package ru.yandex.qe.dispenser.domain.dao.entity.spec;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.EntitySpec;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

public enum EntitySpecUtils {
    ;

    @NotNull
    public static EntitySpec toEntitySpec(@NotNull final String serviceKey, @NotNull final String entitySpecKey) {
        final Hierarchy hierarchy = Hierarchy.get();
        final Service service = hierarchy.getServiceReader().read(serviceKey);
        final ru.yandex.qe.dispenser.domain.EntitySpec.Key key = new EntitySpec.Key(entitySpecKey, service);
        return hierarchy.getEntitySpecReader().read(key);
    }
}
