package ru.yandex.qe.dispenser.domain.dao.goal;

import org.jetbrains.annotations.NotNull;

import ru.yandex.inside.goals.model.Goal.Importance;
import ru.yandex.inside.goals.model.Goal.Status;
import ru.yandex.qe.dispenser.api.v1.DiGoal;
import ru.yandex.qe.dispenser.domain.index.LongIndexBase;

public class BaseGoal extends LongIndexBase {

    @NotNull
    private final String name;
    @NotNull
    private final Importance importance;
    @NotNull
    private final Status status;

    public BaseGoal(@NotNull final Long id, @NotNull final String name, @NotNull final Importance goalImportance,
                    @NotNull final Status goalStatus) {
        setId(id);
        this.name = name;
        this.importance = goalImportance;
        this.status = goalStatus;
    }

    @NotNull
    public String getName() {
        return name;
    }

    @NotNull
    public Importance getImportance() {
        return importance;
    }

    @NotNull
    public Status getStatus() {
        return status;
    }

    @NotNull
    public DiGoal toView() {
        return new DiGoal(getId(), name);
    }

    @Override
    public String toString() {
        return "Goal{" +
                "name='" + name + '\'' +
                ", importance=" + importance +
                ", status=" + status +
                '}';
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final BaseGoal goal = (BaseGoal) o;
        return getId() == goal.getId();
    }
}
