package ru.yandex.qe.dispenser.domain.dao.goal;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

import org.jetbrains.annotations.Nullable;

public class OkrAncestors {

    public enum OkrType {
        VALUE_STREAM,
        UMBRELLA,
        CONTOUR
    }

    public static final OkrAncestors EMPTY = new OkrAncestors(Collections.emptyMap());

    private final Map<OkrType, Long> goalIdByType;

    public OkrAncestors(final Map<OkrType, Long> goalIdByType) {
        this.goalIdByType = goalIdByType;
    }

    @Nullable
    public Long getGoalId(final OkrType type) {
        return goalIdByType.get(type);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final OkrAncestors that = (OkrAncestors) o;
        return Objects.equals(goalIdByType, that.goalIdByType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goalIdByType);
    }
}
