package ru.yandex.qe.dispenser.domain.dao.history;

import java.time.Instant;
import java.util.Collection;

import ru.yandex.qe.dispenser.api.v1.DiOrder;
import ru.yandex.qe.dispenser.domain.HistoryEvent;
import ru.yandex.qe.dispenser.domain.util.RelativePage;
import ru.yandex.qe.dispenser.domain.util.RelativePageInfo;

public interface HistoryDao<T extends HistoryEvent, F, HF extends HistoryFilter> {
    T create(T event);

    void create(Collection<T> events);

    T read(long id);

    RelativePage<T> read(F filter, HF historyFilter, RelativePageInfo pageInfo, DiOrder order);

    boolean clear();

    boolean clearBefore(Instant moment);
}
