package ru.yandex.qe.dispenser.domain.dao.history.quota;

import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.qe.dispenser.api.v1.DiOrder;
import ru.yandex.qe.dispenser.domain.Quota;
import ru.yandex.qe.dispenser.domain.QuotaHistoryEvent;
import ru.yandex.qe.dispenser.domain.dao.InMemoryLongKeyDaoImpl;
import ru.yandex.qe.dispenser.domain.dao.history.HistoryFilter;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaDao;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaReader;
import ru.yandex.qe.dispenser.domain.util.HistoryDaoUtils;
import ru.yandex.qe.dispenser.domain.util.Page;
import ru.yandex.qe.dispenser.domain.util.PageInfo;
import ru.yandex.qe.dispenser.domain.util.RelativePage;
import ru.yandex.qe.dispenser.domain.util.RelativePageInfo;

public class QuotaHistoryDaoImpl extends InMemoryLongKeyDaoImpl<QuotaHistoryEvent> implements QuotaHistoryDao {

    @Autowired
    private QuotaDao quotaDao;

    @Override
    public RelativePage<QuotaHistoryEvent> read(final Quota.Key quotaKey, final HistoryFilter filter, final RelativePageInfo pageInfo, final DiOrder order) {
        return HistoryDaoUtils.relativePage(filter(e -> e.getQuotaKey().equals(quotaKey)).filter(HistoryDaoUtils.asPredicate(filter)), pageInfo, order);
    }

    @Override
    public void create(final Collection<QuotaHistoryEvent> events) {
        events.forEach(this::create);
    }

    @Override
    public QuotaHistoryEvent read(final long id) {
        return super.read(id);
    }

    @Override
    public RelativePage<QuotaHistoryEvent> read(final QuotaReader.QuotaFilterParams filter, final HistoryFilter historyFilter,
                                                final RelativePageInfo pageInfo, final DiOrder order) {
        final Page<Quota> quotas = quotaDao.readPage(filter, new PageInfo(1, Long.MAX_VALUE));
        final Set<Quota.@NotNull Key> keys = quotas.getItems().map(Quota::getKey).collect(Collectors.toSet());
        final Stream<QuotaHistoryEvent> stream = filter(e -> keys.contains(e.getQuotaKey())).filter(HistoryDaoUtils.asPredicate(historyFilter));
        return HistoryDaoUtils.relativePage(stream, pageInfo, order);
    }

    @Override
    public boolean clearBefore(final Instant moment) {
        return deleteAll(filter(e -> e.getUpdated().isBefore(moment)).collect(Collectors.toList()));
    }

    @Override
    public boolean clear() {
        return super.clear();
    }
}
