package ru.yandex.qe.dispenser.domain.dao.person;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.YaGroup;
import ru.yandex.qe.dispenser.domain.dao.InMemoryKeyDao;

public interface PersonDao extends InMemoryKeyDao.Normalized<Person, String>, PersonReader {

    void createIfAbsent(@NotNull final Collection<Person> persons);

    @NotNull
    Set<Person> getAllActive();

    @NotNull
    Map<Long, Set<YaGroup>> getGroupsForAllActiveUsers();

    @NotNull
    PersonMembershipPage getPersonMembershipsPage(final Long fromPersonId, final long limit);

    class PersonMembershipPage {

        private final Map<String, Map<String, Set<Long>>> serviceRolesByLogin;
        private final Long lastId;

        public PersonMembershipPage(final Map<String, Map<String, Set<Long>>> serviceRolesByLogin, final Long lastId) {
            this.serviceRolesByLogin = serviceRolesByLogin;
            this.lastId = lastId;
        }

        public Map<String, Map<String, Set<Long>>> getServiceRolesByLogin() {
            return serviceRolesByLogin;
        }

        public Optional<Long> getLastId() {
            return Optional.ofNullable(lastId);
        }

    }

}
