package ru.yandex.qe.dispenser.domain.dao.person;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.PersonGroupMembership;
import ru.yandex.qe.dispenser.domain.YaGroup;
import ru.yandex.qe.dispenser.domain.dao.InMemoryKeyDao;

public interface PersonGroupMembershipDao extends InMemoryKeyDao.Normalized<PersonGroupMembership, PersonGroupMembership.Key> {

    void createIfAbsent(@NotNull final Collection<PersonGroupMembership> objects);

    @NotNull
    List<PersonGroupMembership> findByPersons(@NotNull final Collection<Person> persons);

    @NotNull
    Set<YaGroup> getAllPersonDepartmentsByPerson(@NotNull final Person person);

    @NotNull
    Set<Long> findPersonIdsByGroupId(final long groupId);

    @NotNull
    Map<Long, Set<Long>> findPersonIdsByGroupIds(@NotNull final Set<Long> groupIds);

    @NotNull
    Set<YaGroup> findGroupsByPersonId(final long personId);

    @NotNull
    Map<Long, Set<YaGroup>> findGroupsByPersonIds(@NotNull final Set<Long> personIds);

    @NotNull
    Map<Long, Set<Long>> findPersonIdsByGroupIdsForProjectMembership();

}
