package ru.yandex.qe.dispenser.domain.dao.project;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiMetaValueSet;
import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.ProjectServiceMeta;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.YaGroup;
import ru.yandex.qe.dispenser.domain.dao.InMemoryKeyDao;
import ru.yandex.qe.dispenser.domain.dao.validation.Validate;
import ru.yandex.qe.dispenser.domain.hierarchy.Role;

public interface ProjectDao extends InMemoryKeyDao.Normalized<Project, Project.Key>, ProjectReader {
    @NotNull
    @Override
    default Project createIfAbsent(@NotNull final Project project) {
        return InMemoryKeyDao.Normalized.super.createIfAbsent(project);
    }

    @NotNull
    @Override
    default Map<Project.Key, Project> createAllIfAbsent(@NotNull final Collection<Project> projects) {
        return InMemoryKeyDao.Normalized.super.createAllIfAbsent(projects);
    }

    @Validate(exists = true)
    default boolean attach(final @NotNull Person user, final @NotNull Project project, @NotNull final Role role) {
        return attachAll(Collections.singleton(user), Collections.emptyList(), project, role);
    }

    @Validate(exists = true)
    default boolean attach(@NotNull final YaGroup group, final @NotNull Project project, @NotNull final Role role) {
        return attachAll(Collections.emptyList(), Collections.singleton(group), project, role);
    }

    @Validate(exists = true)
    boolean attachAll(@NotNull Collection<Person> persons, @NotNull Collection<YaGroup> groups, @NotNull Project project, @NotNull Role role);

    @Validate(exists = true)
    boolean attachAll(@NotNull Collection<Person> persons, @NotNull Collection<YaGroup> groups, @NotNull Project project, long roleId);

    @Validate(exists = true)
    default boolean detach(final @NotNull Person user, final @NotNull Project project, @NotNull final Role role) {
        return detachAll(Collections.singleton(user), Collections.emptyList(), project, role);
    }

    @Validate(exists = true)
    default boolean detach(@NotNull final YaGroup group, final @NotNull Project project, @NotNull final Role role) {
        return detachAll(Collections.emptyList(), Collections.singleton(group), project, role);
    }

    @Validate(exists = true)
    boolean detachAll(@NotNull Collection<Person> persons, @NotNull Collection<YaGroup> groups, @NotNull Project project, @NotNull Role role);

    @Validate(exists = true)
    boolean detachAll(@NotNull Collection<Person> persons, @NotNull Collection<YaGroup> groups, @NotNull Project project, long roleId);

    void detachAll(@NotNull Project project);

    void detachAllPersons(@NotNull Project project);

    @Nullable
    DiMetaValueSet getProjectMeta(@NotNull Project project, @NotNull Service service);

    @NotNull
    Set<ProjectServiceMeta> getAllProjectMetas(); // TODO: concrete arguments for future usecases

    boolean putProjectMeta(@NotNull ProjectServiceMeta projectMeta);

    @NotNull Project lockForUpdate(@NotNull final Project project);

    @NotNull Collection<Project> lockForUpdate(@NotNull final Collection<Project> projects);
}
