package ru.yandex.qe.dispenser.domain.dao.project.role;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Sets;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.ProjectRole;

@ParametersAreNonnullByDefault
public class ProjectRoleDaoImpl implements ProjectRoleDao, ProjectRoleCache {

    @NotNull
    protected final Map<Long, ProjectRole> id2obj = new ConcurrentHashMap<>();
    @NotNull
    private final AtomicLong counter = new AtomicLong();
    @NotNull
    protected final Map<String, ProjectRole> roleByKey = new ConcurrentHashMap<>();

    @Override
    public Set<ProjectRole> getAll() {
        return Sets.newHashSet(id2obj.values());
    }

    @Override
    public ProjectRole getById(final long roleId) {
        return id2obj.get(roleId);
    }

    @Override
    public ProjectRole getByKey(final String key) {
        return Objects.requireNonNull(roleByKey.get(key), "No role with key '" + key + "'");
    }

    @Override
    public ProjectRole create(final ProjectRole role) {
        final long id = counter.getAndIncrement();
        role.setId(id);
        id2obj.put(id, role);
        roleByKey.put(role.getKey(), role);

        return role;
    }

    @Override
    public void clear() {
        roleByKey.clear();
        id2obj.clear();
        counter.set(0);
    }
}
