package ru.yandex.qe.dispenser.domain.dao.property;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.dao.KeyExtractorInMemoryDaoImpl;
import ru.yandex.qe.dispenser.domain.property.Property;

public class PropertyDaoImpl extends KeyExtractorInMemoryDaoImpl<Property, Long> implements PropertyDao, PropertyReader {
    @NotNull
    private final AtomicLong counter = new AtomicLong();

    public PropertyDaoImpl() {
        super(Property::getId);
    }

    @NotNull
    @Override
    public Property create(final @NotNull Property newInstance) {
        final Property property = new Property(counter.incrementAndGet(), newInstance.getEntityKey(), newInstance.getPropertyKey(), newInstance.getValue());
        return super.create(property);
    }

    @Override
    public Set<Property> readAll(final Property.Type<?> type) {
        return filter(p -> p.getValue().getType() == type)
                .collect(Collectors.toSet());
    }

    @Override
    public Optional<Property> read(final String entityKey, final String propertyKey) {
        return filter(p -> p.getEntityKey().equals(entityKey) && p.getPropertyKey().equals(propertyKey))
                .findFirst();
    }

    @Override
    public Set<Property> read(final String entityKey) {
        return filter(p -> p.getEntityKey().equals(entityKey))
                .collect(Collectors.toSet());
    }
}
