package ru.yandex.qe.dispenser.domain.dao.quota;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.Quota;
import ru.yandex.qe.dispenser.domain.QuotaSpec;
import ru.yandex.qe.dispenser.domain.QuotaView;
import ru.yandex.qe.dispenser.domain.Resource;

@ParametersAreNonnullByDefault
public interface QuotaCache {
    @NotNull
    Set<QuotaView> getAll();

    @NotNull
    Set<QuotaView> getQuotas(QuotaSpec quotaSpec);

    @NotNull
    Set<QuotaView> getQuotasByResources(Collection<Resource> resources);

    @NotNull
    Set<QuotaView> getQuotas(@NotNull Collection<Project> projects);

    @NotNull
    QuotaView getQuota(@NotNull Quota.Key key);
}
