package ru.yandex.qe.dispenser.domain.dao.quota;

import java.util.Collections;
import java.util.Set;

import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.Quota;
import ru.yandex.qe.dispenser.domain.QuotaSpec;
import ru.yandex.qe.dispenser.domain.Segment;

public class QuotaKeyFilter implements QuotaReader.QuotaFilterParams {
    private final Set<QuotaSpec> quotaSpecs;
    private final Set<Project> projects;
    private final Set<Segment> segments;

    public QuotaKeyFilter(final Quota.Key key) {
        this.quotaSpecs = Collections.singleton(key.getSpec());
        this.projects = Collections.singleton(key.getProject());
        this.segments = key.getSegments();
    }

    @Override
    public Set<QuotaSpec> getQuotaSpecs() {
        return quotaSpecs;
    }

    @Override
    public Set<Project> getProjects() {
        return projects;
    }

    @Override
    public Set<Segment> getSegments() {
        return segments;
    }
}
