package ru.yandex.qe.dispenser.domain.dao.quota.request;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestImportantFilter;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestSortField;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestUnbalancedFilter;
import ru.yandex.qe.dispenser.api.v1.DiResourcePreorderReasonType;
import ru.yandex.qe.dispenser.domain.Campaign;
import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.Service;

@ParametersAreNonnullByDefault
public class QuotaChangeRequestFilterImpl implements QuotaChangeRequestReader.QuotaChangeRequestFilter {

    private Set<Person> authors = Collections.emptySet();
    private Set<Project> projects = Collections.emptySet();
    private Set<QuotaChangeRequest.Status> statuses = Collections.emptySet();
    private Set<QuotaChangeRequest.Type> types = Collections.emptySet();
    private Set<Service> services = Collections.emptySet();
    private Set<Long> orderIds = Collections.emptySet();
    private Set<Long> campaignIds = Collections.emptySet();
    private Set<Long> campaignOrderIds = Collections.emptySet();
    private Set<Long> goalIds = Collections.emptySet();
    private Set<DiResourcePreorderReasonType> reasonTypes = Collections.emptySet();
    private Set<Long> excludedChangeRequestIds = Collections.emptySet();
    private Optional<Boolean> withoutTicket = Optional.empty();
    private Set<Long> changeRequestIds = Collections.emptySet();
    private Set<Long> preOrderIds = Collections.emptySet();
    @Nullable
    private String summary;
    @Nullable
    private Long owningCostGreaterOrEquals;
    @Nullable
    private Long owningCostLessOrEquals;
    @Nullable
    private DiQuotaChangeRequestImportantFilter importantFilter;
    @Nullable
    private DiQuotaChangeRequestUnbalancedFilter unbalancedFilter;
    @NotNull
    private Set<Campaign.Type> campaignTypes = Collections.emptySet();

    private QuotaChangeRequestReader.SortOrder sortOrder = QuotaChangeRequestReader.SortOrder.DESC;
    private DiQuotaChangeRequestSortField sortBy = DiQuotaChangeRequestSortField.UPDATED_AT;

    @Override
    @NotNull
    public Set<Person> getAuthors() {
        return authors;
    }

    @Override
    @NotNull
    public Set<Project> getProjects() {
        return projects;
    }

    @Override
    @NotNull
    public Set<QuotaChangeRequest.Status> getStatus() {
        return statuses;
    }

    @Override
    @NotNull
    public Set<QuotaChangeRequest.Type> getType() {
        return types;
    }

    @Override
    @NotNull
    public Set<Service> getServices() {
        return services;
    }

    @Override
    @NotNull
    public Set<Long> getOrderIds() {
        return orderIds;
    }

    @Override
    @NotNull
    public Set<Long> getCampaignIds() {
        return campaignIds;
    }

    @Override
    @NotNull
    public Set<Long> getCampaignOrderIds() {
        return campaignOrderIds;
    }

    @NotNull
    @Override
    public Set<Long> getGoalIds() {
        return goalIds;
    }

    @Nonnull
    @Override
    public Set<DiResourcePreorderReasonType> getReasonTypes() {
        return reasonTypes;
    }

    @NotNull
    @Override
    public Set<Long> getExcludedChangeRequestIds() {
        return excludedChangeRequestIds;
    }

    @Override
    @NotNull
    public Optional<Boolean> withoutTicket() {
        return withoutTicket;
    }

    @Override
    @NotNull
    public Set<Long> getChangeRequestIds() {
        return changeRequestIds;
    }

    @Override
    @NotNull
    public Set<Long> getPreOrderIds() {
        return preOrderIds;
    }

    @Override
    @NotNull
    public QuotaChangeRequestReader.SortOrder getSortOrder() {
        return sortOrder;
    }

    @Override
    @NotNull
    public DiQuotaChangeRequestSortField getSortBy() {
        return sortBy;
    }

    @Override
    @NotNull
    public Optional<String> getSummary() {
        return Optional.ofNullable(summary);
    }

    @Override
    @Nullable
    public Long getOwningCostGreaterOrEquals() {
        return owningCostGreaterOrEquals;
    }

    @Override
    @Nullable
    public Long getOwningCostLessOrEquals() {
        return owningCostLessOrEquals;
    }

    @Nullable
    @Override
    public DiQuotaChangeRequestImportantFilter getImportantFilter() {
        return importantFilter;
    }

    @Nullable
    @Override
    public DiQuotaChangeRequestUnbalancedFilter getUnbalancedFilter() {
        return unbalancedFilter;
    }

    @NotNull
    @Override
    public Set<Campaign.Type> getCampaignTypes() {
        return campaignTypes;
    }

    public void setAuthors(final Set<Person> authors) {
        this.authors = authors;
    }

    public void setProjects(final Set<Project> projects) {
        this.projects = projects;
    }

    public void setStatuses(final Set<QuotaChangeRequest.Status> statuses) {
        this.statuses = statuses;
    }

    public void setTypes(final Set<QuotaChangeRequest.Type> types) {
        this.types = types;
    }

    public void setServices(final Set<Service> services) {
        this.services = services;
    }

    public void setOrderIds(final Set<Long> orderIds) {
        this.orderIds = orderIds;
    }

    public void setCampaignIds(final Set<Long> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public void setCampaignOrderIds(final Set<Long> campaignOrderIds) {
        this.campaignOrderIds = campaignOrderIds;
    }

    public void setGoalIds(final Set<Long> goalIds) {
        this.goalIds = goalIds;
    }

    public void setReasonType(final DiResourcePreorderReasonType... reasonType) {
        this.reasonTypes = EnumSet.noneOf(DiResourcePreorderReasonType.class);
        this.reasonTypes.addAll(Arrays.asList(reasonType));
    }

    public void setExcludedChangeRequestIds(final Set<Long> excludedChangeRequestIds) {
        this.excludedChangeRequestIds = excludedChangeRequestIds;
    }

    public void setWithoutTicket(final boolean withoutTicket) {
        this.withoutTicket = Optional.of(withoutTicket);
    }

    public void setChangeRequestIds(final Set<Long> completedRequestIds) {
        this.changeRequestIds = completedRequestIds;
    }

    public void setPreOrderIds(final Set<Long> preOrderIds) {
        this.preOrderIds = preOrderIds;
    }

    public void setSortOrder(final QuotaChangeRequestReader.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void setSortBy(final DiQuotaChangeRequestSortField sortBy) {
        this.sortBy = sortBy;
    }

    public void setSummary(@Nullable final String summary) {
        this.summary = summary;
    }

    public void setOwningCostGreaterOrEquals(Long owningCostGreaterOrEquals) {
        this.owningCostGreaterOrEquals = owningCostGreaterOrEquals;
    }

    public void setOwningCostLessOrEquals(Long owningCostLessOrEquals) {
        this.owningCostLessOrEquals = owningCostLessOrEquals;
    }

    public void setImportantFilter(DiQuotaChangeRequestImportantFilter importantFilter) {
        this.importantFilter = importantFilter;
    }

    public void setUnbalancedFilter(DiQuotaChangeRequestUnbalancedFilter unbalancedFilter) {
        this.unbalancedFilter = unbalancedFilter;
    }

    public void setCampaignTypes(@NotNull Set<Campaign.Type> campaignTypes) {
        this.campaignTypes = campaignTypes;
    }

}
