package ru.yandex.qe.dispenser.domain.dao.quota.request;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.dao.EmptyResultDataAccessException;

import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestImportantFilter;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestSortField;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestUnbalancedFilter;
import ru.yandex.qe.dispenser.api.v1.DiResourcePreorderReasonType;
import ru.yandex.qe.dispenser.domain.Campaign;
import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.util.Page;
import ru.yandex.qe.dispenser.domain.util.PageInfo;

@ParametersAreNonnullByDefault
public interface QuotaChangeRequestReader {
    @NotNull
    Set<QuotaChangeRequest> getAll();

    @NotNull
    QuotaChangeRequest read(final long id) throws EmptyResultDataAccessException;

    @NotNull
    Optional<QuotaChangeRequest> findByTicketKey(final String ticketKey);

    Map<String, QuotaChangeRequest> findByTicketKeys(Collection<String> ticketKeys);

    @NotNull
    List<QuotaChangeRequest> read(final QuotaChangeRequestFilter filter);

    @NotNull
    Stream<QuotaChangeRequest> readStream(QuotaChangeRequestFilter filter);

    @NotNull
    Page<QuotaChangeRequest> readPage(QuotaChangeRequestFilter filter, PageInfo pageInfo);

    @NotNull
    Map<Resource, Long> readAggregation(QuotaChangeRequestFilter filter);

    @NotNull
    List<QuotaChangeRequest> readRequestsWithFilteredChanges(final QuotaChangeRequestFilter filter);

    @NotNull
    List<RequestPreOrderAggregationEntry> readPreOrderAggregation(final QuotaChangeRequestFilter filter);

    interface QuotaChangeRequestFilter {
        @NotNull
        Set<Person> getAuthors();

        @NotNull
        Set<Project> getProjects();

        @NotNull
        Set<QuotaChangeRequest.Status> getStatus();

        @NotNull
        Set<QuotaChangeRequest.Type> getType();

        @NotNull
        Set<Service> getServices();

        @NotNull
        Set<Long> getOrderIds();

        @NotNull
        Set<Long> getCampaignIds();

        @NotNull
        Set<Long> getCampaignOrderIds();

        @NotNull
        Set<Long> getGoalIds();

        @NotNull
        Set<DiResourcePreorderReasonType> getReasonTypes();

        @NotNull
        Set<Long> getExcludedChangeRequestIds();

        @NotNull
        Optional<Boolean> withoutTicket();

        @NotNull
        Set<Long> getChangeRequestIds();

        @NotNull
        Set<Long> getPreOrderIds();

        @NotNull
        SortOrder getSortOrder();

        @NotNull
        DiQuotaChangeRequestSortField getSortBy();

        @NotNull
        Optional<String> getSummary();

        @Nullable
        Long getOwningCostGreaterOrEquals();

        @Nullable
        Long getOwningCostLessOrEquals();

        @Nullable
        DiQuotaChangeRequestImportantFilter getImportantFilter();

        @Nullable
        DiQuotaChangeRequestUnbalancedFilter getUnbalancedFilter();

        @NotNull
        Set<Campaign.Type> getCampaignTypes();

    }

    enum SortOrder {
        ASC,
        DESC
    }
}
