package ru.yandex.qe.dispenser.domain.dao.quota.request;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.dao.goal.OkrAncestors;

@ParametersAreNonnullByDefault
public class ReportQuotaChangeRequest {
    private final QuotaChangeRequest request;
    private final Map<Long, String> goalData;
    private final Map<OkrAncestors.OkrType, Goal> goalHierarchy;

    public ReportQuotaChangeRequest(final QuotaChangeRequest request, final Map<Long, String> goalData,
                                    final Map<OkrAncestors.OkrType, Goal> goalHierarchy) {
        this.request = request;
        this.goalData = goalData;
        this.goalHierarchy = goalHierarchy;
    }

    public QuotaChangeRequest getRequest() {
        return request;
    }

    public Map<Long, String> getGoalData() {
        return goalData;
    }

    public Map<OkrAncestors.OkrType, Goal> getGoalHierarchy() {
        return goalHierarchy;
    }

    public static class Goal {
        private final long id;
        @NotNull
        private final String name;

        public Goal(final long id, @NotNull final String name) {
            this.id = id;
            this.name = name;
        }

        public long getId() {
            return id;
        }

        @NotNull
        public String getName() {
            return name;
        }
    }


}
