package ru.yandex.qe.dispenser.domain.dao.quota.request;

import java.util.Objects;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

public class ResourceSegments {

    private final long resourceId;
    @NotNull
    private final Set<Long> segmentIds;

    public ResourceSegments(final long resourceId, @NotNull final Set<Long> segmentIds) {
        this.resourceId = resourceId;
        this.segmentIds = segmentIds;
    }

    public long getResourceId() {
        return resourceId;
    }

    @NotNull
    public Set<Long> getSegmentIds() {
        return segmentIds;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ResourceSegments that = (ResourceSegments) o;
        return resourceId == that.resourceId &&
                segmentIds.equals(that.segmentIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, segmentIds);
    }

    @Override
    public String toString() {
        return "ResourceSegments{" +
                "resourceId=" + resourceId +
                ", segmentIds=" + segmentIds +
                '}';
    }

}
