package ru.yandex.qe.dispenser.domain.dao.quota.request.collector;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.dao.SqlUtils;

@ParametersAreNonnullByDefault
public class StatusUpdatedRequestCollector
        extends BaseRequestCollector<Stream<Pair<QuotaChangeRequest, QuotaChangeRequest>>> {
    private final Map<Long, QuotaChangeRequest.Status> oldStatusById = new HashMap<>();
    private final Map<Long, Long> oldUpdatedById = new HashMap<>();

    @Override
    protected void processFirstRequestRow(final ResultSet rs, final long requestId) throws SQLException {
        super.processFirstRequestRow(rs, requestId);
        oldStatusById.put(requestId, QuotaChangeRequest.Status.valueOf(rs.getString("old_status")));
        oldUpdatedById.put(requestId, SqlUtils.toTime(rs.getTimestamp("old_updated")));
    }

    @Override
    @NotNull
    public Stream<Pair<QuotaChangeRequest, QuotaChangeRequest>> get() {
        return requestsBuilders.stream()
                .map(builder -> {
                    final QuotaChangeRequest request = builder.build();
                    final QuotaChangeRequest oldRequest = request.copyBuilder()
                            .status(oldStatusById.get(request.getId()))
                            .updated(oldUpdatedById.get(request.getId()))
                            .build();
                    return Pair.of(request, oldRequest);
                });
    }
}
