package ru.yandex.qe.dispenser.domain.dao.quota.segment;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.Segmentation;
import ru.yandex.qe.dispenser.domain.dao.SqlDaoBase;
import ru.yandex.qe.dispenser.domain.dao.segment.SqlSegmentDao;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;


@ParametersAreNonnullByDefault
public class SqlQuotaSegmentDao extends SqlDaoBase {
    public static final String DELETE_BY_SEGMENT_QUERY = "DELETE FROM quota_segment WHERE segment_id = :segmentId";


    public static Segment toSegment(@NotNull final ResultSet rs, final int i) throws SQLException {
        final long segmentId = rs.getLong("segment_id");
        if (rs.wasNull()) {
            final long segmentationId = rs.getLong("segmentation_id");
            final Segmentation segmentation = Hierarchy.get().getSegmentationReader().read(segmentationId);
            return Segment.totalOf(segmentation);
        }
        return Hierarchy.get().getSegmentReader().read(segmentId);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public boolean removeBySegment(final Segment segment) {
        return jdbcTemplate.update(DELETE_BY_SEGMENT_QUERY, SqlSegmentDao.toParams(segment)) > 0;
    }
}
